#!/usr/bin/wish
#

#
# I am D. Richard Hipp, the author of this code.  I hereby
# disavow all claims to copyright on this program and release
# it into the public domain. 
#
#                     D. Richard Hipp
#                     January 31, 2001
#
# Modification by Victor Wagner (2004) are also placed into public domai
#
#
# As an historical record, the original copyright notice is
# reproduced below:
#
# Copyright (C) 1997,1998 D. Richard Hipp
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
# 
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA  02111-1307, USA.
#
# Author contact information:
#   drh@acm.org
#   http://www.hwaci.com/drh/
#
# $Revision: 1.7 $
#
option add *highlightThickness 0

namespace eval tree {
switch $tcl_platform(platform) {
  unix {
    set Tree_font \
      -*-helvetica-medium-r-normal-*-11-80-100-100-p-56-*-*
  }
  windows {
    set Tree_font \
      -*-helvetica-medium-r-normal-*-14-100-100-100-p-76-*-*
  }
}

#
# Create a new tree widget.  $args become the configuration arguments to
# the canvas widget from which the tree is constructed.
#
proc create {w args} {
  variable $w
  upvar 0 $w data
  variable Tree_font
  array set data {
  	sorted 0
	offset 17
  }	
  set data(font) $Tree_font
	

  eval canvas $w -bg white [stealOptions $w $args]
  bind $w <Destroy> {::tree::delitem %W /}
  defaultItemConfig $w /
  buildwhenidle $w
  set data(selection) {}
  set data(selidx) {}
}
#
# Parses option list, removing duplicates and copies tree-specific
# options into array in the namespace. Returns list of options which
# should be passed to underlying widget
#
proc stealOptions {w argList} {
  variable $w
  upvar 0 $w data
  array set config $argList
  foreach treearg {-sorted -offset -font} {
  	if {[info exists config($treearg)]} {
		set data([string range $treearg 1 end]) $config($treearg)
		unset config($treearg)
	}
  }
  return [array get config]
}  
	
# Initialize a element of the tree.
# Internal use only
#
proc defaultItemConfig {w v} {
  variable $w
  upvar 0 $w data
  set data($v:children) {}
  set data($v:open) 0
  set data($v:icon) {}
  set data($v:tags) {}
}

#
# Pass configuration options to the tree widget
#
proc configure {w args} {
  eval $w config [stealOptions $w $args]
}

#
# Insert a new element $v into the tree $w.
#
proc newitem {w v args} {
  variable $w
  upvar 0 $w data
  set dir [file dirname $v]
  set n [file tail $v]
  if {![info exists data($dir:open)]} {
    return -code error "parent item \"$dir\" is missing"
  }
  set i [lsearch -exact $data($dir:children) $n]
  if {$i>=0} {
    return -code error "item \"$v\" already exists"
  }
  lappend data($dir:children) $n
  if {$data(sorted)} {
  	set data($dir:children) [lsort $data($dir:children)]
  }	
  defaultItemConfig $w $v
  foreach {op arg} $args {
    switch -exact -- $op {
      -image {set data($v:icon) $arg}
      -tags {set data($v:tags) $arg}
    }
  }
  buildwhenidle $w
}

#
# Delete element $v from the tree $w.  If $v is /, then the widget is
# deleted.
#
proc delitem {w v} {
  variable $w
  upvar 0 $w data
  if {![info exists data($v:open)]} return
  if {[string compare $v /]==0} {
    # delete the whole widget
    catch {destroy $w}
	array unset data
	return
  }
  foreach c $data($v:children) {
    catch {delitem $w $v/$c}
  }
  unset data($v:open)
  unset data($v:children)
  unset data($v:icon)
  set dir [file dirname $v]
  set n [file tail $v]
  set i [lsearch -exact $data($dir:children) $n]
  if {$i>=0} {
    set data($dir:children) [lreplace $data($dir:children) $i $i]
  }
  buildwhenidle $w
}

#
# Change the selection to the indicated item
#
proc setselection {w v} {
  variable $w
  upvar 0 $w data
  if {[string length $v]&&![info exists data($v:open)]} {
  	return -code error "node \"$v\" doesn't exists"
  }	
  set data(selection) $v
  drawselection $w
}

# 
# Retrieve the current selection
#
proc getselection w {
  variable $w
  upvar 0 $w data
  return $data(selection)
}

#
# Bitmaps used to show which parts of the tree can be opened.
#
set maskdata "#define solid_width 9\n#define solid_height 9"
append maskdata {
  static unsigned char solid_bits[] = {
   0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01, 0xff, 0x01,
   0xff, 0x01, 0xff, 0x01, 0xff, 0x01
  };
}
set data "#define open_width 9\n#define open_height 9"
append data {
  static unsigned char open_bits[] = {
   0xff, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7d, 0x01, 0x01, 0x01,
   0x01, 0x01, 0x01, 0x01, 0xff, 0x01
  };
}
image create bitmap Tree:openbm -data $data -maskdata $maskdata \
  -foreground black -background white
set data "#define closed_width 9\n#define closed_height 9"
append data {
  static unsigned char closed_bits[] = {
   0xff, 0x01, 0x01, 0x01, 0x11, 0x01, 0x11, 0x01, 0x7d, 0x01, 0x11, 0x01,
   0x11, 0x01, 0x01, 0x01, 0xff, 0x01
  };
}
image create bitmap Tree:closedbm -data $data -maskdata $maskdata \
  -foreground black -background white

# Internal use only.
# Draw the tree on the canvas
proc build w {
  variable $w
  upvar 0 $w data
  $w delete all
  catch {unset data(buildpending)}
  set data(y) 30
  buildlayer $w / 10
  $w config -scrollregion [$w bbox all]
  drawselection $w
}

# Internal use only.
# Build a single layer of the tree on the canvas.  Indent by $in pixels
proc buildlayer {w v in} {
  variable $w
  upvar 0 $w data
  if {$v=="/"} {
    set vx {}
  } else {
    set vx $v
  }
  set start [expr $data(y)-10]
  foreach c $data($v:children) {
    set y $data(y)
    incr data(y) $data(offset)
    $w create line $in $y [expr $in+10] $y -fill gray50 
    set icon $data($vx/$c:icon)
    set taglist x
    foreach tag $data($vx/$c:tags) {
      lappend taglist $tag
    }
    set x [expr $in+12]
    if {[string length $icon]>0} {
      set k [$w create image $x $y -image $icon -anchor w -tags $taglist]
      incr x 20
      set data(tag:$k) $vx/$c
    }
    set j [$w create text $x $y -text $c -font $data(font) \
                                -anchor w -tags $taglist]
    set data(tag:$j) $vx/$c
    set data($vx/$c:tag) $j
    if {[string length $data($vx/$c:children)]} {
      if {$data($vx/$c:open)} {
         set j [$w create image $in $y -image Tree:openbm]
         $w bind $j <1> "set \"::tree::$w\($vx/$c:open\)\" 0; tree::build $w"
         buildlayer $w $vx/$c [expr $in+18]
      } else {
         set j [$w create image $in $y -image Tree:closedbm]
         $w bind $j <1> "set \"::tree::$w\($vx/$c:open\)\" 1; tree::build $w"
      }
    }
  }
  set j [$w create line $in $start $in [expr $y+1] -fill gray50 ]
  $w lower $j
}

# Open a branch of a tree
#
proc open {w v} {
  variable $w 
  upvar 0 $w data
  if {[info exists data($v:open)] && $data($v:open)==0
      && [info exists data($v:children)] 
      && [llength $data($v:children)]>0} {
    set data($v:open) 1
    build $w
  }
}

#
# Close a branch of tree
#
proc close {w v} {
  variable $w 
  upvar 0 $w data
  if {[info exists data($v:open)] && $data($v:open)==1} {
    set data($v:open) 0
    build $w
  }
}

# Internal use only.
# Draw the selection highlight
proc drawselection w {
  variable $w 
  upvar 0 $w data
  if {[string length $data(selidx)]} {
    $w delete $data(selidx)
  }
  set v $data(selection)
  if {[string length $v]==0} return
  if {![info exists data($v:tag)]} return
  set bbox [$w bbox $data($v:tag)]
  if {[llength $bbox]==4} {
    set i [eval $w create rectangle $bbox -fill skyblue -outline {{}}]
    set data(selidx) $i
    $w lower $i
  } else {
    set data(selidx) {}
  }
}

# Internal use only
# Call Tree:build then next time we're idle
proc buildwhenidle w {
  variable $w 
  upvar 0 $w data
  if {![info exists data(buildpending)]} {
    set data(buildpending) 1
    after idle "::tree::build $w"
  }
}

#
# Return the full pathname of the label for widget $w that is located
# at real coordinates $x, $y
#
proc labelat {w x y} {
  set x [$w canvasx $x]
  set y [$w canvasy $y]
  variable $w 
  upvar 0 $w data
  foreach m [$w find overlapping $x $y $x $y] {
    if {[info exists data(tag:$m)]} {
      return $data(tag:$m)
    }
  }
  return ""
}


#
# Return tags for given node.
#
#

proc gettags {w node} {
	variable $w
	upvar 0 $w data
	if {[info exists data($node:tags)]} {
		return $data($node:tags)
	} else {
		return ""
	}	
}	

#
# Return list of nodes which have given tag 
#
proc findtag {w tag} {
	variable $w 
	upvar 0 $w data
	set res {}
	foreach {item tags} [array get data *:tags] {
		if {[lsearch -exact $tags $tag]!= -1} {
			lappend res [lindex [split $item ":"] 0]
		}
	}
	return $res
}

#
# Sets selection to given item and makes this item visible
# (i.e. expands all branches above)
# 

proc select {w v} {
	set list [split $v /]
	for {set i 1} {$i<[llength $list]} {incr i} {
		set parent [join [lrange $list 0 $i] /]
		open $w $parent
	}
	setselection $w $v
}	

}

package provide tree 1.0
