.TH "unixhelp" n 1.0 unixhelp "Tk Unixhelp"


.SH "NAME"

unixhelp \- Tcl/Tk package to display context-sensitive help

.SH "SYNOPSIS"

package require \fBunixhelp\fR

\fBunixhelp\fR \fI$window\fR \fIfilename\fR ?\fIpage\fR?#\fIanchor\fR??

.SH DESCRIPTION

This package provides helpviewer which looks much like Microsoft Windows
help viewer and uses help files, generated from same sources as Window
.chm files using
.BR tkhhc (1).
Scripting interface is compatible with Christian Werner's 
.B winhelp 
package.
.PP
First argument of the \fBunixhelp\fR command is Tk window pathName,
which is used as parent for toplevel help window.
.PP
Second argument is name of help file.
.PP
If third argument is specified, it is used as name of html page
(possibly with anchor) in the archive. If third argument is not
specified, default topic would be shown.
.PP
Subsequentual calls with same window name would result in reloading
contents of same help window.
.SH REQUIRED PACKAGES
\fBunixhelp\fR requires following Tcl/Tk packages to be installed
.TP 8
.B Tkhtml
.TP 8
.B Vfs (tclvfs)
.TP 8
.B memchan
.TP 8
.B Trf

.SH SEE ALSO
.BR tkhmtl (n),
.BR tkhhc (1),
http://www.ch-werner.de/winhelp

.SH AUTHOR
Victor Wagner <vitus@45.free.net>
