
package require Tkhtml 2.0
package require notebook
package require tree
package require vfs

bind HtmlClip <Motion> {
  set parent [winfo parent %W]
  set url [$parent href %x %y] 
  if {[string length $url] > 0} {
    $parent configure -cursor hand2
  } else {
    $parent configure -cursor {}
  }
}
 bind Html <4> {
	if {!$tk_strictMotif} {
	    %W yview scroll -5 units
	}
    }
bind Html <5> {
	
	if {!$tk_strictMotif} {
	    %W yview scroll 5 units
	}
	}
 bind HtmlClip <4> {
	if {!$tk_strictMotif} {
	    [winfo parent %W] yview scroll -5 units
	}
    }
bind HtmlClip <5> {
	
	if {!$tk_strictMotif} {
	    [winfo parent %W] yview scroll 5 units
	}
	}

bind HtmlClip <B1-Motion> {
	set _htmltempvar [winfo parent %W]
	set mark [set ::unixhelp::${_htmltempvar}(mark)]
	[winfo parent %W] selection set @$mark @%x,%y
}

bind HtmlClip <<Copy>> {
	puts stderr "Copiing selection to clipboard"
	set data [[winfo parent %W] text ascii sel.first sel.last]
	if {[string length $data]} {
		puts stderr "Got [string length $data] characters"
		clipboard clear
		clipboard append $data
	}
}	

image create photo idir -data {
    R0lGODdhEAAQAPIAAAAAAHh4eLi4uPj4APj4+P///wAAAAAAACwAAAAAEAAQAAADPVi63P4w
    LkKCtTTnUsXwQqBtAfh910UU4ugGAEucpgnLNY3Gop7folwNOBOeiEYQ0acDpp6pGAFArVqt
    hQQAO///
}
image create photo ifile -data {
    R0lGODdhEAAQAPIAAAAAAHh4eLi4uPj4+P///wAAAAAAAAAAACwAAAAAEAAQAAADPkixzPOD
    yADrWE8qC8WN0+BZAmBq1GMOqwigXFXCrGk/cxjjr27fLtout6n9eMIYMTXsFZsogXRKJf6u
    P0kCADv/
}
namespace eval unixhelp {

# 
# Message catalog for Russian language. Should use proper ru.msg and
# mcload 
#
package require msgcat
#
# message catalog
#
::msgcat::mcload [file dirname [info script]]
proc unixhelp {window filename {page ""}} {
	set w [popupHelpWindow $window]
	setHelpFile $w $filename
	showTopic $w $page
}

proc popupHelpWindow {parent} {
	if {$parent eq "."} {
		set w .help
	} else {
		set w $parent.$help
	}
	if {![winfo exists $w]} {
		createHelpWindow $w
	}
	wm deiconify $w
	raise $w
	focus -force $w
	return $w
}

proc setHelpFile {window file} {
	variable $window
	upvar 0 $window w
	if {[info exists w(filename)]} {
		if  {"$w(filename)" eq [file normalize $file]} {
			return
		} else {
			vfs::filesystem unmount /help_vfs
		}	
	}
	variable ${window}_imagecache
	if {[array exist ${window}_imagecache]} {
		foreach {imgname img} [array get ${window}_imagecache] {
			image delete $img
		}
		array unset ${window}_imagecache
	}	
	set w(filename) [file normalize $file]
	::vfs::zip::Mount $file /help_vfs
	if {[file exists /help_vfs/props.txt]} {
		set f [open /help_vfs/props.txt]
		array set w [read -nonewline $f]
		close $f
	} else {
		set w(encoding) [encoding system]
	}	
	variable ${window}_meta
	if {[array exists ${window}_meta]} {
	  array unset ${window}_meta
	} 
	array set ${window}_meta {}
	if {[file exists /help_vfs/meta.lst]} {
		set f [open /help_vfs/meta.lst]
		fconfigure $f -encoding $w(encoding)
		array set ${window}_meta [read $f]
		close $f
	}	
	setContentsTable $window
	setKeywordIndex $window
}	
		
proc showTopic {window {page {}}} {
	variable $window
	upvar 0 $window w
	if {![string length $page]} {
		set page $w(starttopic)
	}
	if {[regexp {^(.+)#([^#]+)$} $page match f anchor]}  {
		set page $f
	}	
	set f [open /help_vfs/$page]
	$window.p.right.html clear
	fconfigure $f -encoding $w(encoding)
	$window.p.right.html parse [read $f]
	close $f
	if {[info exist anchor]} {
		$window.p.right.html yview $anchor
	}	
	if {[info exists w(curpage)]} {
		pushHistory $window $w(curpage)
	}	
	set w(curpage) $page
	if {[info exists w(forward)]} {unset w(forward)}
	$window.forward configure -state disabled
	setContentsTopic $window $page
}	

proc pushHistory {window page} {
	variable $window
	upvar 0 $window w
	if {![info exists w(history)]} {
		$window.back configure -state normal
	}
	lappend w(history) $page
}

proc historyBack {window} {
	variable $window
	upvar 0 $window w
	if {![info exists w(history)]||![llength $w(history)]} return
	set h [lrange $w(history) 0 end-1]
	if {[info exists w(forward)]} {
		set f [concat $w(forward) [list $w(curpage)]]
	} else {
		set f [list $w(curpage)]
	}	
	showTopic $window [lindex $w(history) end]
	set w(history) $h
	set w(forward) $f
	if {![llength $h]} {
		$window.back configure -state disabled
	}	
	$window.forward configure -state normal
}

proc historyForward {window} {
	variable $window
	upvar 0 $window w
	if {![info exists w(forward)]||![llength $w(forward)]} return
	set f [lrange $w(forward) 0 end-1]
	showTopic $window [lindex $w(forward) end]
	set w(forward) $f
	if {[llength $f]} {
		$window.forward configure -state normal
	}
}	
proc createTreePane {w hw} {
	::tree::create $w.tree -width 150 -height 550 -yscrollcommand [list $w.y set] -xscrollcommand [list $w.x set]
	scrollbar $w.y -orient vert -command [list $w.tree yview]
	scrollbar $w.x -orient horiz -command [list $w.tree xview]
	grid $w.tree $w.y -sticky news
	grid $w.x x -sticky news
	grid rowconfigure $w 0 -weight 1
	grid columnconfigure $w 0 -weight 1
	$w.tree bind x <1>	"
		set lbl \[::tree::labelat %W %x %y\]
		if {\[string length \$lbl\]} {
		::unixhelp::showTopic $hw \[::tree::gettags %W \$lbl\]
		}
	"	
		
}

proc processLink {w url args} {
	set url [lindex $url 0]
	if {[regexp "CHM= *META=(.*)" $url match haid]} {
		variable ${w}_meta
		if {[info exists ${w}_meta($haid)]} {
			set url [set ${w}_meta($haid)]
		} else {
			# fallback
			set url $haid.htm
		}
	}	
	showTopic $w $url
}

proc HtmlClick {window x y} {
	variable $window
	upvar 0 $window w
	$window selection clear
	set w(mark) $x,$y
	set url [$window href $x $y] 
	if {[string length $url]} {
		processLink [winfo parent [winfo parent [winfo parent $window]]] [lindex $url 0]
	}
}

proc ScriptCmd {args} {

}


proc FormCmd {args} {

}
proc createHelpWindow {window} {
	toplevel $window
	button $window.back -text [::msgcat::mc Back]  -state disabled\
	-command [list ::unixhelp::historyBack $window]	
	button $window.forward -text [::msgcat::mc Forward] -state disabled\
	 -command [list ::unixhelp::historyForward $window]
	button $window.start -text [::msgcat::mc "Start page"] -command "::unixhelp::showTopic $window" 
	panedwindow $window.p -orient horiz
	frame $window.p.right
	notebook $window.p.n [::msgcat::mc Contents] [::msgcat::mc Index] [::msgcat::mc Search] 
	$window.p add $window.p.n $window.p.right
	
	html $window.p.right.html -padx 5 -pady 9\
	-yscrollcommand "$window.p.right.y set"\
	-xscrollcommand "$window.p.right.x set"\
  -formcommand ::unixhelp::FormCmd \
  -imagecommand [list ::unixhelp::ImageCmd $window] \
  -scriptcommand ::unixhelp::ScriptCmd \
  -appletcommand ::unixhelp::AppletCmd \
  -underlinehyperlinks 0 \
	-bg white -tablerelief raised -underlinehyperlinks 0
	bind $window.p.right.html <1> {::unixhelp::HtmlClick %W %x %y}	
	bind $window.p.right.html.x <1> {event generate [winfo parent %W] <1> -x %x -y %y}	
	scrollbar $window.p.right.y -command "$window.p.right.html yview"
	scrollbar $window.p.right.x -orient horiz -command "$window.p.right.html xview"
	grid $window.p.right.html $window.p.right.y -sticky news
	grid $window.p.right.x x -sticky news
	grid columnconfigure $window.p.right 0 -weight 1
	grid columnconfigure $window.p.right 1 -weight 0
	grid rowconfigure $window.p.right 0 -weight 1
	createTreePane [getNote $window.p.n [::msgcat::mc Contents]] $window
	createTreePane [getNote $window.p.n [::msgcat::mc Index]] $window
	set search [getNote $window.p.n [::msgcat::mc Search]]
	entry $search.term
	bind $search.term <Return> [list $search.topics invoke]
	bind $search.term <Expose> {focus %W}
	button $search.topics -text [::msgcat::mc Topics] -command [list ::unixhelp::searchPages $window]
	listbox $search.result -yscrollcommand [list $search.y set]
	scrollbar $search.y -command [list $search.result yview]
	bind $search.result <Double-1> "%W selection set \[%W index @%x,%y\];$search.show invoke"
	bind $search.result <Key-Return> "$search.show invoke"
	button $search.show -text [::msgcat::mc Show] -command [list ::unixhelp::showFound $window] -state disabled
	grid $search.term - - -sticky news
	grid x $search.topics - -sticky news -padx 20 -pady 10
	grid $search.result - $search.y -sticky news
	grid x $search.show - -sticky news -padx 20 -pady 10
	grid columnconfigure $search 0 -weight 1
	grid rowconfigure $search 2 -weight 1
	grid $window.back $window.forward $window.start x -sticky news
	grid $window.p - - - -sticky news
	grid columnconfigure $window 3 -weight 1
	grid rowconfigure $window 1 -weight 1
}

proc createTree {window list {parent {}}} {
	set nodename $parent/[lindex $list 0]
	set nodetag [lindex $list 1]
	if {[llength $list]>2} {
		set image idir
	} else {
		set image ifile
	}	
	::tree::newitem $window $nodename -image $image -tags $nodetag
	foreach subtree [lrange $list 2 end] {
		createTree $window $subtree $nodename
	}	
}

proc fillTree {window tree file} {
	variable $window
	upvar 0 $window w
	set f [open /help_vfs/$file]
	fconfigure $f -encoding $w(encoding)
	foreach rootnode [read $f] {
		createTree $tree $rootnode ""
	}
	close $f
}

proc setContentsTable {window} {
	fillTree $window [getNote $window.p.n [::msgcat::mc Contents]].tree contents.lst
}

proc setKeywordIndex {window} {
	fillTree $window [getNote $window.p.n [::msgcat::mc Index]].tree index.lst
}

proc setContentsTopic {window topic} {
	set tree [getNote $window.p.n [::msgcat::mc Contents]].tree
	set lbl [lindex [::tree::findtag $tree $topic] 0]
	::tree::select $tree $lbl
	set tree2 [getNote  $window.p.n [::msgcat::mc Index]].tree
	::tree::setselection $tree2 ""
}

proc searchPages {window} {
	variable $window
	variable search_name
	variable index_name
	upvar 0 $window w
	set pane [getNote $window.p.n  [::msgcat::mc Search]]
	set contents [getNote $window.p.n [::msgcat::mc Contents]].tree
	set term [$pane.term get]
	set w(search_result) {}
	$pane.result delete 0 end
	foreach page [glob /help_vfs/*.htm] {
		set f [open $page]
		fconfigure $f -encoding $w(encoding)
		set html [read $f]
		close $f
		if {[regexp -nocase -- $term $html]} {
			set page [file tail $page]
			set title [file tail [lindex [::tree::findtag $contents $page] 0]]
			if {![string length $title]} {
				if {[regexp -nocase "<title>(.*)</title>" $html match t]} {
					set title $t
				} else {
					puts "Untitled page $page"
				}	
			}	
			lappend	w(search_result) $page
			$pane.result insert end $title
		}
	}	
	if {[llength $w(search_result)]} {
		$pane.show configure -state normal
	}	
 	$pane.result selection set 0
	focus $pane.result
}		

proc showFound {window} {
	variable $window 
	upvar 0 $window w
	set box [getNote $window.p.n [::msgcat::mc Search]].result
	if {![llength [$box curselection]]} return
	showTopic $window [lindex $w(search_result) [$box curselection]]
}	

proc ImageCmd {window filename width height args} {
	variable ${window}_imagecache
	upvar 0 ${window}_imagecache cache
	if {[info exists cache($filename)]} {
		return $cache($filename)
	}	
	if {[catch {set img [image create photo -file [file join /help_vfs $filename]]} msg]} {
		return -code error $msg
	 } else {
		set cache($filename) $img
		return $img
	}	
}

namespace export unixhelp
}
namespace import unixhelp::*
package provide unixhelp 1.1


